'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Bankname_Exit(Cancel As Integer)
    Me.Bankname = Trim(Me.Bankname)
End Sub

Private Sub Befehl93_Click()
    
    
    
    
    Dim x As Integer
    Dim t As String
    Dim AZ As String
    Dim t2 As String
    Dim pos As Integer
    
    AZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    
    'Leerzeichen vorn und hinten entfernen
    Me.BIC = Trim(Me.BIC)
    Me.IBAN = Trim(Me.IBAN)
    Me.KontoInhaber = Trim(Me.KontoInhaber)
    'Pflichtfelder prfen
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.KontoInhaber)) = 0) Or IsNull(Me.KontoInhaber)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr den KontoInhaber Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.KontoInhaber.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.IBAN)) = 0) Or IsNull(Me.IBAN)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die IBAN Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.IBAN.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.BIC)) = 0) Or IsNull(Me.BIC)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die BIC Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.BIC.SetFocus
        Exit Sub
    End If
    'Prfung auf ISO646-Zeichensatz (ASCII), fr QR-Code-Tauglichkeit
    If Len(Me.BIC) > 0 Then
        For x = 1 To Len(Me.BIC)
            If (AscW(Mid(Me.BIC, x, 1)) < 32) Or (AscW(Mid(Me.BIC, x, 1)) > 126) Then
                MsgBox "Die BIC enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.BIC.SetFocus
                Me.BIC.SelStart = x - 1
                Me.BIC.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    If Len(Me.IBAN) > 0 Then
        For x = 1 To Len(Me.IBAN)
            If (AscW(Mid(Me.IBAN, x, 1)) < 32) Or (AscW(Mid(Me.IBAN, x, 1)) > 126) Then
                MsgBox "Die IBAN enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    ' IBAN prfen -------------------------------------------------
    If Len(Me.IBAN) > 0 Then
        t = Me.IBAN
        'auf Grobuchstaben am Anfang prfen:
        'Position 1
        If (AscW(Left(t, 1)) < 65) Or (AscW(Left(t, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 0
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'Position 2
        If (AscW(Mid(t, 2, 1)) < 65) Or (AscW(Mid(t, 2, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 2
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'ansonsten nur Ziffern (oder Leerzeichen) erlaubt
        For x = 3 To Len(t)
            If (Mid(t, x, 1) <> " ") And (AscW(Mid(t, x, 1)) < 48) Or (AscW(Mid(t, x, 1)) > 57) Then
                MsgBox "In der IBAN sind nach der Lnderkennung nur Ziffern (oder Leerzeichen) erlaubt.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
        'alle Leerzeichen entfernen
        Do While InStr(1, t, " ") > 0
            t = Replace(t, " ", "")
        Loop
        'Lnge der IBAN erneut prfen
        If Len(t) < 16 Then
            If MsgBox("Die IBAN scheint zu kurz zu sein." & vbNewLine & _
                      "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                Me.IBAN.SetFocus
                Exit Sub
            End If
        End If
        'IBAN per Prfziffer prfen: dazu muss die umgestellte Nummer mit Modulus 97 den Rest 1 ergeben
        If Len(t) >= 5 Then
            'Nummer neu zusammensetzen:
            '1. die Ziffern ab der 5. Position bis zum Ende
            '2. die Lnderkennung als Zahlen hinten anhngen
            '3. die Prfziffern hinten anhngen
            t = Mid(t, 5) & Format((InStr(1, AZ, Left(t, 1)) + 9), "00") & Format((InStr(1, AZ, Mid(t, 2, 1)) + 9), "00") & Mid(t, 3, 2)
            ' da ein Modulus "t mod 97" mit so einem riesigen t immer 0 ergibt bzw. einen berlauf erzeugt(!),
            ' erfolgt die Simulation einer "Schriftlichen" Division mit Ermittlung des Restes:
            t2 = ""
            ' t von links nach rechts durchgehen
            For pos = 1 To Len(t)
                ' nchste Ziffer aus t holen
                t2 = t2 & Mid(t, pos, 1)
                'wenn t2 < 97, dann nchste Ziffer aus t holen,
                'sonst Division durch 97 und den Rest wieder in t2 merken
                '(das eigentliche Ergebnis der Division wird verworfen,
                'da es hier nicht von Interesse ist)
                If Val(t2) >= 97 Then
                    ' t2 kann durch 97 geteilt werden,
                    'also Rest fr die nchste Rechnung ermitteln
                    t2 = Format(Val(t2) Mod 97, "#########0")
                End If
            Next pos
            'wenn der Rest = 1 ist, ist die IBAN formal okay
            If Val(t2) <> 1 Then
                If MsgBox("Die IBAN scheint nicht zu stimmen." & vbNewLine & _
                          "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                    Me.IBAN.SetFocus
                    Exit Sub
                End If
            End If
        End If
    End If
    
    
    
    
    
    
    
    'Formular schlieen
    DoCmd.Close
    
End Sub

Private Sub Button_ReNr_Festlegen_Click()
On Error GoTo Err_Button_ReNr_Festlegen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
          
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen"
    
    'Eigentliches Formular ffnen
    stDocName = "Rechnungsnummern"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
        
Exit_Button_ReNr_Festlegen_Click:
    Exit Sub

Err_Button_ReNr_Festlegen_Click:
    MsgBox err.Description
    Resume Exit_Button_ReNr_Festlegen_Click

End Sub

Private Sub Button_ReNr_Hilfe_Click()
On Error GoTo Err_Button_ReNr_Hilfe_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
          
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Einstellungen"
    
    'Eigentliches Formular ffnen
    stDocName = "ReNrAufbauHinweis"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
        
Exit_Button_ReNr_Hilfe_Click:
    Exit Sub

Err_Button_ReNr_Hilfe_Click:
    MsgBox err.Description
    Resume Exit_Button_ReNr_Hilfe_Click

End Sub

Private Sub Button_ReNr_Standard_Click()
    If MsgBox("Wollen Sie das Schema fr die Rechnungsnummer wirklich auf den Standardwert '[JJJJ]######' einstellen?", vbYesNo + vbQuestion + vbDefaultButton2, "Schema fr Rechnungsnummer zurcksetzen...") = vbNo Then
        Exit Sub
    End If
    Me.ReNr_Aufbau.Value = "[JJJJ]######"
End Sub

Private Sub Firmenlogo_DblClick(Cancel As Integer)
    On Error Resume Next
    Me.Firmenlogo.Action = acOLEDelete
    Me.Firmenlogo.Action = acOLEInsertObjDlg
    Me.Firmenlogo.Action = acOLEEither
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Kategorien", acSaveYes
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub IBAN_Exit(Cancel As Integer)
    Me.IBAN = Trim(Me.IBAN)
End Sub

Private Sub KontoInhaber_Exit(Cancel As Integer)
    Me.KontoInhaber = Trim(Me.KontoInhaber)
End Sub

Private Sub ZuEinstellungen2_Click()
On Error GoTo Err_ZuEinstellungen2_Click

    Dim stDocName As String
    Dim stLinkCriteria As String





    Dim x As Integer
    Dim t As String
    Dim AZ As String
    Dim t2 As String
    Dim pos As Integer
    
    AZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    
    'Leerzeichen vorn und hinten entfernen
    Me.BIC = Trim(Me.BIC)
    Me.IBAN = Trim(Me.IBAN)
    Me.KontoInhaber = Trim(Me.KontoInhaber)
    'Pflichtfelder prfen
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.KontoInhaber)) = 0) Or IsNull(Me.KontoInhaber)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr den KontoInhaber Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.KontoInhaber.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.IBAN)) = 0) Or IsNull(Me.IBAN)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die IBAN Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.IBAN.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.BIC)) = 0) Or IsNull(Me.BIC)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die BIC Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.BIC.SetFocus
        Exit Sub
    End If
    'Prfung auf ISO646-Zeichensatz (ASCII), fr QR-Code-Tauglichkeit
    If Len(Me.BIC) > 0 Then
        For x = 1 To Len(Me.BIC)
            If (AscW(Mid(Me.BIC, x, 1)) < 32) Or (AscW(Mid(Me.BIC, x, 1)) > 126) Then
                MsgBox "Die BIC enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.BIC.SetFocus
                Me.BIC.SelStart = x - 1
                Me.BIC.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    If Len(Me.IBAN) > 0 Then
        For x = 1 To Len(Me.IBAN)
            If (AscW(Mid(Me.IBAN, x, 1)) < 32) Or (AscW(Mid(Me.IBAN, x, 1)) > 126) Then
                MsgBox "Die IBAN enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    ' IBAN prfen -------------------------------------------------
    If Len(Me.IBAN) > 0 Then
        t = Me.IBAN
        'auf Grobuchstaben am Anfang prfen:
        'Position 1
        If (AscW(Left(t, 1)) < 65) Or (AscW(Left(t, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 0
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'Position 2
        If (AscW(Mid(t, 2, 1)) < 65) Or (AscW(Mid(t, 2, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 2
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'ansonsten nur Ziffern (oder Leerzeichen) erlaubt
        For x = 3 To Len(t)
            If (Mid(t, x, 1) <> " ") And (AscW(Mid(t, x, 1)) < 48) Or (AscW(Mid(t, x, 1)) > 57) Then
                MsgBox "In der IBAN sind nach der Lnderkennung nur Ziffern (oder Leerzeichen) erlaubt.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
        'alle Leerzeichen entfernen
        Do While InStr(1, t, " ") > 0
            t = Replace(t, " ", "")
        Loop
        'Lnge der IBAN erneut prfen
        If Len(t) < 16 Then
            If MsgBox("Die IBAN scheint zu kurz zu sein." & vbNewLine & _
                      "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                Me.IBAN.SetFocus
                Exit Sub
            End If
        End If
        'IBAN per Prfziffer prfen: dazu muss die umgestellte Nummer mit Modulus 97 den Rest 1 ergeben
        If Len(t) >= 5 Then
            'Nummer neu zusammensetzen:
            '1. die Ziffern ab der 5. Position bis zum Ende
            '2. die Lnderkennung als Zahlen hinten anhngen
            '3. die Prfziffern hinten anhngen
            t = Mid(t, 5) & Format((InStr(1, AZ, Left(t, 1)) + 9), "00") & Format((InStr(1, AZ, Mid(t, 2, 1)) + 9), "00") & Mid(t, 3, 2)
            ' da ein Modulus "t mod 97" mit so einem riesigen t immer 0 ergibt bzw. einen berlauf erzeugt(!),
            ' erfolgt die Simulation einer "Schriftlichen" Division mit Ermittlung des Restes:
            t2 = ""
            ' t von links nach rechts durchgehen
            For pos = 1 To Len(t)
                ' nchste Ziffer aus t holen
                t2 = t2 & Mid(t, pos, 1)
                'wenn t2 < 97, dann nchste Ziffer aus t holen,
                'sonst Division durch 97 und den Rest wieder in t2 merken
                '(das eigentliche Ergebnis der Division wird verworfen,
                'da es hier nicht von Interesse ist)
                If Val(t2) >= 97 Then
                    ' t2 kann durch 97 geteilt werden,
                    'also Rest fr die nchste Rechnung ermitteln
                    t2 = Format(Val(t2) Mod 97, "#########0")
                End If
            Next pos
            'wenn der Rest = 1 ist, ist die IBAN formal okay
            If Val(t2) <> 1 Then
                If MsgBox("Die IBAN scheint nicht zu stimmen." & vbNewLine & _
                          "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                    Me.IBAN.SetFocus
                    Exit Sub
                End If
            End If
        End If
    End If
    
    
    
    
    
    
    
    
    stDocName = "Einstellungen_2"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen", acSaveYes
    

Exit_ZuEinstellungen2_Click:
    Exit Sub

Err_ZuEinstellungen2_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen2_Click
    
End Sub

Private Sub ZuEinstellungen3_Click()
On Error GoTo Err_ZuEinstellungen3_Click

    Dim stDocName As String
    Dim stLinkCriteria As String



    
    
    Dim x As Integer
    Dim t As String
    Dim AZ As String
    Dim t2 As String
    Dim pos As Integer
    
    AZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    
    'Leerzeichen vorn und hinten entfernen
    Me.BIC = Trim(Me.BIC)
    Me.IBAN = Trim(Me.IBAN)
    Me.KontoInhaber = Trim(Me.KontoInhaber)
    'Pflichtfelder prfen
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.KontoInhaber)) = 0) Or IsNull(Me.KontoInhaber)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr den KontoInhaber Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.KontoInhaber.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.IBAN)) = 0) Or IsNull(Me.IBAN)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die IBAN Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.IBAN.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.BIC)) = 0) Or IsNull(Me.BIC)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die BIC Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.BIC.SetFocus
        Exit Sub
    End If
    'Prfung auf ISO646-Zeichensatz (ASCII), fr QR-Code-Tauglichkeit
    If Len(Me.BIC) > 0 Then
        For x = 1 To Len(Me.BIC)
            If (AscW(Mid(Me.BIC, x, 1)) < 32) Or (AscW(Mid(Me.BIC, x, 1)) > 126) Then
                MsgBox "Die BIC enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.BIC.SetFocus
                Me.BIC.SelStart = x - 1
                Me.BIC.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    If Len(Me.IBAN) > 0 Then
        For x = 1 To Len(Me.IBAN)
            If (AscW(Mid(Me.IBAN, x, 1)) < 32) Or (AscW(Mid(Me.IBAN, x, 1)) > 126) Then
                MsgBox "Die IBAN enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    ' IBAN prfen -------------------------------------------------
    If Len(Me.IBAN) > 0 Then
        t = Me.IBAN
        'auf Grobuchstaben am Anfang prfen:
        'Position 1
        If (AscW(Left(t, 1)) < 65) Or (AscW(Left(t, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 0
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'Position 2
        If (AscW(Mid(t, 2, 1)) < 65) Or (AscW(Mid(t, 2, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 2
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'ansonsten nur Ziffern (oder Leerzeichen) erlaubt
        For x = 3 To Len(t)
            If (Mid(t, x, 1) <> " ") And (AscW(Mid(t, x, 1)) < 48) Or (AscW(Mid(t, x, 1)) > 57) Then
                MsgBox "In der IBAN sind nach der Lnderkennung nur Ziffern (oder Leerzeichen) erlaubt.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
        'alle Leerzeichen entfernen
        Do While InStr(1, t, " ") > 0
            t = Replace(t, " ", "")
        Loop
        'Lnge der IBAN erneut prfen
        If Len(t) < 16 Then
            If MsgBox("Die IBAN scheint zu kurz zu sein." & vbNewLine & _
                      "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                Me.IBAN.SetFocus
                Exit Sub
            End If
        End If
        'IBAN per Prfziffer prfen: dazu muss die umgestellte Nummer mit Modulus 97 den Rest 1 ergeben
        If Len(t) >= 5 Then
            'Nummer neu zusammensetzen:
            '1. die Ziffern ab der 5. Position bis zum Ende
            '2. die Lnderkennung als Zahlen hinten anhngen
            '3. die Prfziffern hinten anhngen
            t = Mid(t, 5) & Format((InStr(1, AZ, Left(t, 1)) + 9), "00") & Format((InStr(1, AZ, Mid(t, 2, 1)) + 9), "00") & Mid(t, 3, 2)
            ' da ein Modulus "t mod 97" mit so einem riesigen t immer 0 ergibt bzw. einen berlauf erzeugt(!),
            ' erfolgt die Simulation einer "Schriftlichen" Division mit Ermittlung des Restes:
            t2 = ""
            ' t von links nach rechts durchgehen
            For pos = 1 To Len(t)
                ' nchste Ziffer aus t holen
                t2 = t2 & Mid(t, pos, 1)
                'wenn t2 < 97, dann nchste Ziffer aus t holen,
                'sonst Division durch 97 und den Rest wieder in t2 merken
                '(das eigentliche Ergebnis der Division wird verworfen,
                'da es hier nicht von Interesse ist)
                If Val(t2) >= 97 Then
                    ' t2 kann durch 97 geteilt werden,
                    'also Rest fr die nchste Rechnung ermitteln
                    t2 = Format(Val(t2) Mod 97, "#########0")
                End If
            Next pos
            'wenn der Rest = 1 ist, ist die IBAN formal okay
            If Val(t2) <> 1 Then
                If MsgBox("Die IBAN scheint nicht zu stimmen." & vbNewLine & _
                          "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                    Me.IBAN.SetFocus
                    Exit Sub
                End If
            End If
        End If
    End If








    stDocName = "Einstellungen_3"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen", acSaveYes
    

Exit_ZuEinstellungen3_Click:
    Exit Sub

Err_ZuEinstellungen3_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen3_Click
    
End Sub

Private Sub ZuEinstullungen4_Click()
On Error GoTo Err_ZuEinstellungen4_Click

    Dim stDocName As String
    Dim stLinkCriteria As String






    Dim x As Integer
    Dim t As String
    Dim AZ As String
    Dim t2 As String
    Dim pos As Integer
    
    AZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    
    'Leerzeichen vorn und hinten entfernen
    Me.BIC = Trim(Me.BIC)
    Me.IBAN = Trim(Me.IBAN)
    Me.KontoInhaber = Trim(Me.KontoInhaber)
    'Pflichtfelder prfen
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.KontoInhaber)) = 0) Or IsNull(Me.KontoInhaber)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr den KontoInhaber Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.KontoInhaber.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.IBAN)) = 0) Or IsNull(Me.IBAN)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die IBAN Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.IBAN.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.BIC)) = 0) Or IsNull(Me.BIC)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die BIC Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.BIC.SetFocus
        Exit Sub
    End If
    'Prfung auf ISO646-Zeichensatz (ASCII), fr QR-Code-Tauglichkeit
    If Len(Me.BIC) > 0 Then
        For x = 1 To Len(Me.BIC)
            If (AscW(Mid(Me.BIC, x, 1)) < 32) Or (AscW(Mid(Me.BIC, x, 1)) > 126) Then
                MsgBox "Die BIC enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.BIC.SetFocus
                Me.BIC.SelStart = x - 1
                Me.BIC.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    If Len(Me.IBAN) > 0 Then
        For x = 1 To Len(Me.IBAN)
            If (AscW(Mid(Me.IBAN, x, 1)) < 32) Or (AscW(Mid(Me.IBAN, x, 1)) > 126) Then
                MsgBox "Die IBAN enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    ' IBAN prfen -------------------------------------------------
    If Len(Me.IBAN) > 0 Then
        t = Me.IBAN
        'auf Grobuchstaben am Anfang prfen:
        'Position 1
        If (AscW(Left(t, 1)) < 65) Or (AscW(Left(t, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 0
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'Position 2
        If (AscW(Mid(t, 2, 1)) < 65) Or (AscW(Mid(t, 2, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 2
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'ansonsten nur Ziffern (oder Leerzeichen) erlaubt
        For x = 3 To Len(t)
            If (Mid(t, x, 1) <> " ") And (AscW(Mid(t, x, 1)) < 48) Or (AscW(Mid(t, x, 1)) > 57) Then
                MsgBox "In der IBAN sind nach der Lnderkennung nur Ziffern (oder Leerzeichen) erlaubt.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
        'alle Leerzeichen entfernen
        Do While InStr(1, t, " ") > 0
            t = Replace(t, " ", "")
        Loop
        'Lnge der IBAN erneut prfen
        If Len(t) < 16 Then
            If MsgBox("Die IBAN scheint zu kurz zu sein." & vbNewLine & _
                      "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                Me.IBAN.SetFocus
                Exit Sub
            End If
        End If
        'IBAN per Prfziffer prfen: dazu muss die umgestellte Nummer mit Modulus 97 den Rest 1 ergeben
        If Len(t) >= 5 Then
            'Nummer neu zusammensetzen:
            '1. die Ziffern ab der 5. Position bis zum Ende
            '2. die Lnderkennung als Zahlen hinten anhngen
            '3. die Prfziffern hinten anhngen
            t = Mid(t, 5) & Format((InStr(1, AZ, Left(t, 1)) + 9), "00") & Format((InStr(1, AZ, Mid(t, 2, 1)) + 9), "00") & Mid(t, 3, 2)
            ' da ein Modulus "t mod 97" mit so einem riesigen t immer 0 ergibt bzw. einen berlauf erzeugt(!),
            ' erfolgt die Simulation einer "Schriftlichen" Division mit Ermittlung des Restes:
            t2 = ""
            ' t von links nach rechts durchgehen
            For pos = 1 To Len(t)
                ' nchste Ziffer aus t holen
                t2 = t2 & Mid(t, pos, 1)
                'wenn t2 < 97, dann nchste Ziffer aus t holen,
                'sonst Division durch 97 und den Rest wieder in t2 merken
                '(das eigentliche Ergebnis der Division wird verworfen,
                'da es hier nicht von Interesse ist)
                If Val(t2) >= 97 Then
                    ' t2 kann durch 97 geteilt werden,
                    'also Rest fr die nchste Rechnung ermitteln
                    t2 = Format(Val(t2) Mod 97, "#########0")
                End If
            Next pos
            'wenn der Rest = 1 ist, ist die IBAN formal okay
            If Val(t2) <> 1 Then
                If MsgBox("Die IBAN scheint nicht zu stimmen." & vbNewLine & _
                          "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                    Me.IBAN.SetFocus
                    Exit Sub
                End If
            End If
        End If
    End If







    stDocName = "Einstellungen_4"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen", acSaveYes
    

Exit_ZuEinstellungen4_Click:
    Exit Sub

Err_ZuEinstellungen4_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen4_Click
    
End Sub

Private Sub ZuEinstullungen6_Click()
On Error GoTo Err_ZuEinstellungen6_Click

    Dim stDocName As String
    Dim stLinkCriteria As String






    Dim x As Integer
    Dim t As String
    Dim AZ As String
    Dim t2 As String
    Dim pos As Integer
    
    AZ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    
    'Leerzeichen vorn und hinten entfernen
    Me.BIC = Trim(Me.BIC)
    Me.IBAN = Trim(Me.IBAN)
    Me.KontoInhaber = Trim(Me.KontoInhaber)
    'Pflichtfelder prfen
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.KontoInhaber)) = 0) Or IsNull(Me.KontoInhaber)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr den KontoInhaber Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.KontoInhaber.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.IBAN)) = 0) Or IsNull(Me.IBAN)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die IBAN Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.IBAN.SetFocus
        Exit Sub
    End If
    If (Me.QR_JaNein = True) And ((Len(Trim(Me.BIC)) = 0) Or IsNull(Me.BIC)) Then
        MsgBox "Sie haben in den Optionen den QR-Code fr die Rechnungen aktiviert." & vbNewLine & _
               "Bitte hinterlegen Sie dafr die BIC Ihrer Bankverbindung.", vbCritical + vbOKOnly, "Fehler"
        Me.BIC.SetFocus
        Exit Sub
    End If
    'Prfung auf ISO646-Zeichensatz (ASCII), fr QR-Code-Tauglichkeit
    If Len(Me.BIC) > 0 Then
        For x = 1 To Len(Me.BIC)
            If (AscW(Mid(Me.BIC, x, 1)) < 32) Or (AscW(Mid(Me.BIC, x, 1)) > 126) Then
                MsgBox "Die BIC enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.BIC.SetFocus
                Me.BIC.SelStart = x - 1
                Me.BIC.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    If Len(Me.IBAN) > 0 Then
        For x = 1 To Len(Me.IBAN)
            If (AscW(Mid(Me.IBAN, x, 1)) < 32) Or (AscW(Mid(Me.IBAN, x, 1)) > 126) Then
                MsgBox "Die IBAN enthlt mindestens ein ungltiges Zeichen.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
    End If
    ' IBAN prfen -------------------------------------------------
    If Len(Me.IBAN) > 0 Then
        t = Me.IBAN
        'auf Grobuchstaben am Anfang prfen:
        'Position 1
        If (AscW(Left(t, 1)) < 65) Or (AscW(Left(t, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 0
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'Position 2
        If (AscW(Mid(t, 2, 1)) < 65) Or (AscW(Mid(t, 2, 1)) > 90) Then
            MsgBox "Die IBAN muss mit einer Lnderkennug beginnen (zwei Grobuchstaben).", vbCritical + vbOKOnly, "Fehler"
            Me.IBAN.SetFocus
            Me.IBAN.SelStart = 2
            Me.IBAN.SelLength = 1
            Exit Sub
        End If
        'ansonsten nur Ziffern (oder Leerzeichen) erlaubt
        For x = 3 To Len(t)
            If (Mid(t, x, 1) <> " ") And (AscW(Mid(t, x, 1)) < 48) Or (AscW(Mid(t, x, 1)) > 57) Then
                MsgBox "In der IBAN sind nach der Lnderkennung nur Ziffern (oder Leerzeichen) erlaubt.", vbCritical + vbOKOnly, "Fehler"
                Me.IBAN.SetFocus
                Me.IBAN.SelStart = x - 1
                Me.IBAN.SelLength = 1
                Exit Sub
            End If
        Next x
        'alle Leerzeichen entfernen
        Do While InStr(1, t, " ") > 0
            t = Replace(t, " ", "")
        Loop
        'Lnge der IBAN erneut prfen
        If Len(t) < 16 Then
            If MsgBox("Die IBAN scheint zu kurz zu sein." & vbNewLine & _
                      "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                Me.IBAN.SetFocus
                Exit Sub
            End If
        End If
        'IBAN per Prfziffer prfen: dazu muss die umgestellte Nummer mit Modulus 97 den Rest 1 ergeben
        If Len(t) >= 5 Then
            'Nummer neu zusammensetzen:
            '1. die Ziffern ab der 5. Position bis zum Ende
            '2. die Lnderkennung als Zahlen hinten anhngen
            '3. die Prfziffern hinten anhngen
            t = Mid(t, 5) & Format((InStr(1, AZ, Left(t, 1)) + 9), "00") & Format((InStr(1, AZ, Mid(t, 2, 1)) + 9), "00") & Mid(t, 3, 2)
            ' da ein Modulus "t mod 97" mit so einem riesigen t immer 0 ergibt bzw. einen berlauf erzeugt(!),
            ' erfolgt die Simulation einer "Schriftlichen" Division mit Ermittlung des Restes:
            t2 = ""
            ' t von links nach rechts durchgehen
            For pos = 1 To Len(t)
                ' nchste Ziffer aus t holen
                t2 = t2 & Mid(t, pos, 1)
                'wenn t2 < 97, dann nchste Ziffer aus t holen,
                'sonst Division durch 97 und den Rest wieder in t2 merken
                '(das eigentliche Ergebnis der Division wird verworfen,
                'da es hier nicht von Interesse ist)
                If Val(t2) >= 97 Then
                    ' t2 kann durch 97 geteilt werden,
                    'also Rest fr die nchste Rechnung ermitteln
                    t2 = Format(Val(t2) Mod 97, "#########0")
                End If
            Next pos
            'wenn der Rest = 1 ist, ist die IBAN formal okay
            If Val(t2) <> 1 Then
                If MsgBox("Die IBAN scheint nicht zu stimmen." & vbNewLine & _
                          "Mchten Sie die IBAN prfen?", vbExclamation + vbYesNo + vbDefaultButton1) = vbYes Then
                    Me.IBAN.SetFocus
                    Exit Sub
                End If
            End If
        End If
    End If







    stDocName = "Einstellungen_6"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen", acSaveYes
    

Exit_ZuEinstellungen6_Click:
    Exit Sub

Err_ZuEinstellungen6_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen6_Click
    End Sub
